/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.Counter;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AsLuckWouldHaveItEffect
extends OneShotEffect {
    AsLuckWouldHaveItEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a number of luck counters on {this} equal to the result. Then if there are 100 or more luck counters on {this}, you win the game.";
    }

    private AsLuckWouldHaveItEffect(AsLuckWouldHaveItEffect effect) {
        super((OneShotEffect)effect);
    }

    public AsLuckWouldHaveItEffect copy() {
        return new AsLuckWouldHaveItEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (controller != null && permanent != null && this.getValue("rolled") != null) {
            Player player;
            int amount = (Integer)this.getValue("rolled");
            permanent.addCounters(new Counter(CounterType.LUCK.getName(), amount), source.getControllerId(), source, game);
            if (permanent.getCounters(game).getCount(CounterType.LUCK) >= 100 && (player = game.getPlayer(permanent.getControllerId())) != null) {
                player.won(game);
            }
            return true;
        }
        return false;
    }
}

