/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.common.DealsCombatDamageToAPlayerTriggeredAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AscendantSpiritAngelEffect
extends OneShotEffect {
    AscendantSpiritAngelEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is an Angel, put two +1/+1 counters on it and it gains \"Whenever this creature deals combat damage to a player, draw a card.\"";
    }

    private AscendantSpiritAngelEffect(AscendantSpiritAngelEffect effect) {
        super((OneShotEffect)effect);
    }

    public AscendantSpiritAngelEffect copy() {
        return new AscendantSpiritAngelEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.ANGEL, game)) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(2), source.getControllerId(), source, game);
        game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)new DealsCombatDamageToAPlayerTriggeredAbility((Effect)new DrawCardSourceControllerEffect(1), false), Duration.Custom), source);
        return true;
    }
}

