/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.AddCardSubTypeSourceEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessSourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AscendantSpiritWarriorEffect
extends OneShotEffect {
    AscendantSpiritWarriorEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is a Warrior, put a flying counter on it and it becomes a Spirit Warrior Angel with base power and toughness 4/4";
    }

    private AscendantSpiritWarriorEffect(AscendantSpiritWarriorEffect effect) {
        super((OneShotEffect)effect);
    }

    public AscendantSpiritWarriorEffect copy() {
        return new AscendantSpiritWarriorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null || !permanent.hasSubtype(SubType.WARRIOR, game)) {
            return false;
        }
        permanent.addCounters(CounterType.FLYING.createInstance(), source.getControllerId(), source, game);
        game.addEffect((ContinuousEffect)new AddCardSubTypeSourceEffect(Duration.Custom, new SubType[]{SubType.SPIRIT, SubType.WARRIOR, SubType.ANGEL}), source);
        game.addEffect((ContinuousEffect)new SetBasePowerToughnessSourceEffect(4, 4, Duration.Custom), source);
        return true;
    }
}

