/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class AshadTheLoneCybermanWatcher
extends Watcher {
    private final Map<UUID, Integer> nonlegendaryArtifactSpells = new HashMap<UUID, Integer>();

    public AshadTheLoneCybermanWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Spell spell;
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (spell = (Spell)game.getObject(event.getTargetId())) != null && !spell.isLegendary(game) && spell.isArtifact(game)) {
            this.nonlegendaryArtifactSpells.put(event.getPlayerId(), this.nonlegendaryArtifactSpellsCastThisTurn(event.getPlayerId()) + 1);
        }
    }

    public int nonlegendaryArtifactSpellsCastThisTurn(UUID playerId) {
        return this.nonlegendaryArtifactSpells.getOrDefault(playerId, 0);
    }

    public void reset() {
        super.reset();
        this.nonlegendaryArtifactSpells.clear();
    }
}

