/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.cards.Card;
import mage.constants.PhaseStep;
import mage.game.Game;
import mage.players.Player;

enum AshenGhoulCondition implements Condition
{
    instance;


    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (game.getTurnStepType() != PhaseStep.UPKEEP || !game.isActivePlayer(source.getControllerId())) {
            return false;
        }
        if (controller != null) {
            int cardsAbove = 0;
            boolean aboveCards = false;
            for (Card card : controller.getGraveyard().getCards(game)) {
                if (aboveCards && card.isCreature(game) && ++cardsAbove > 2) {
                    return true;
                }
                if (!card.getId().equals(source.getSourceId())) continue;
                aboveCards = true;
            }
        }
        return false;
    }

    public String toString() {
        return "during your upkeep and only if three or more creature cards are above this card";
    }
}

