/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AsmodeusTheArchfiendReplacementEffect
extends ReplacementEffectImpl {
    AsmodeusTheArchfiendReplacementEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Exile);
        this.staticText = "If you would draw a card, exile the top card of your library face down instead";
    }

    private AsmodeusTheArchfiendReplacementEffect(AsmodeusTheArchfiendReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public AsmodeusTheArchfiendReplacementEffect copy() {
        return new AsmodeusTheArchfiendReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DRAW_CARD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getPlayerId().equals(source.getControllerId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        if (controller != null && sourcePermanent != null && (card = controller.getLibrary().getFromTop(game)) != null) {
            UUID exileZoneId = CardUtil.getExileZoneId((Game)game, (UUID)sourcePermanent.getId(), (int)sourcePermanent.getZoneChangeCounter(game));
            String exileName = CardUtil.createObjectRelatedWindowTitle((Ability)source, (Game)game, null);
            controller.moveCardsToExile(card, source, game, false, exileZoneId, exileName);
            card.setFaceDown(true, game);
        }
        return true;
    }
}

