/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;

enum AspectOfWolfValue implements DynamicValue
{
    UP(true),
    DOWN(false);

    private static final FilterPermanent filter;
    private final boolean up;

    private AspectOfWolfValue(boolean up) {
        this.up = up;
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int forestCount = game.getBattlefield().count(filter, sourceAbility.getControllerId(), sourceAbility, game);
        return forestCount / 2 + (this.up ? forestCount % 2 : 0);
    }

    public AspectOfWolfValue copy() {
        return this;
    }

    public String toString() {
        return this.up ? "X" : "Y";
    }

    public String getMessage() {
        return "half the number of Forests you control, rounded " + (this.up ? "up" : "down");
    }

    static {
        filter = new FilterControlledPermanent(SubType.FOREST);
    }
}

