/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.cards.a.AthreosShroudVeiledEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;

class AthreosShroudVeiledTriggeredAbility
extends TriggeredAbilityImpl {
    AthreosShroudVeiledTriggeredAbility() {
        super(Zone.BATTLEFIELD, null, false);
        this.setLeavesTheBattlefieldTrigger(true);
    }

    private AthreosShroudVeiledTriggeredAbility(AthreosShroudVeiledTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.ZONE_CHANGE) {
            return false;
        }
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        return zEvent.getFromZone() == Zone.BATTLEFIELD && (zEvent.getToZone() == Zone.GRAVEYARD || zEvent.getToZone() == Zone.EXILED);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        Permanent permanent = zEvent.getTarget();
        if (permanent == null || !permanent.isCreature(game) || !permanent.getCounters(game).containsKey(CounterType.COIN)) {
            return false;
        }
        this.getEffects().clear();
        this.addEffect((Effect)new AthreosShroudVeiledEffect(new MageObjectReference((MageObject)zEvent.getTarget(), game)));
        return true;
    }

    public AthreosShroudVeiledTriggeredAbility copy() {
        return new AthreosShroudVeiledTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever a creature with a coin counter on it dies or is put into exile, return that card to the battlefield under your control.";
    }
}

