/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

public final class AuraBarbs
extends CardImpl {
    public AuraBarbs(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{R}");
        this.subtype.add((Object)SubType.ARCANE);
        this.getSpellAbility().addEffect((Effect)new AuraBarbsEffect());
    }

    private AuraBarbs(AuraBarbs card) {
        super((CardImpl)card);
    }

    public AuraBarbs copy() {
        return new AuraBarbs(this);
    }

    private static class AuraBarbsEffect
    extends OneShotEffect {
        public AuraBarbsEffect() {
            super(Outcome.Detriment);
            this.staticText = "Each enchantment deals 2 damage to its controller, then each Aura attached to a creature deals 2 damage to the creature it's attached to";
        }

        private AuraBarbsEffect(AuraBarbsEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            FilterPermanent filterEnchantments = new FilterPermanent();
            filterEnchantments.add((Predicate)CardType.ENCHANTMENT.getPredicate());
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filterEnchantments, source.getControllerId(), source, game)) {
                Player controller = game.getPlayer(permanent.getControllerId());
                if (controller == null) continue;
                controller.damage(2, permanent.getId(), source, game);
                game.informPlayers("2 damage assigned to " + controller.getLogName() + " from " + permanent.getName());
            }
            filterEnchantments.add((Predicate)SubType.AURA.getPredicate());
            for (Permanent auraEnchantment : game.getBattlefield().getActivePermanents(filterEnchantments, source.getControllerId(), source, game)) {
                Permanent attachedToCreature;
                if (auraEnchantment.getAttachedTo() == null || (attachedToCreature = game.getPermanent(auraEnchantment.getAttachedTo())) == null || !attachedToCreature.isCreature(game)) continue;
                attachedToCreature.damage(2, auraEnchantment.getId(), source, game, false, true);
                game.informPlayers("2 damage assigned to " + attachedToCreature.getName() + " from " + auraEnchantment.getName());
            }
            return true;
        }

        public AuraBarbsEffect copy() {
            return new AuraBarbsEffect(this);
        }
    }
}

