/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.TrampleAbility;
import mage.abilities.keyword.VigilanceAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AureliaExemplarOfJusticeEffect
extends OneShotEffect {
    AureliaExemplarOfJusticeEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose up to one target creature you control. Until end of turn, that creature gets +2/+0, gains trample if it's red, and gains vigilance if it's white.";
    }

    private AureliaExemplarOfJusticeEffect(AureliaExemplarOfJusticeEffect effect) {
        super((OneShotEffect)effect);
    }

    public AureliaExemplarOfJusticeEffect copy() {
        return new AureliaExemplarOfJusticeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent creature = game.getPermanent(source.getFirstTarget());
        if (creature == null) {
            return false;
        }
        game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 0, Duration.EndOfTurn), source);
        if (creature.getColor(game).isRed()) {
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)TrampleAbility.getInstance(), Duration.EndOfTurn), source);
        }
        if (creature.getColor(game).isWhite()) {
            game.addEffect((ContinuousEffect)new GainAbilityTargetEffect((Ability)VigilanceAbility.getInstance(), Duration.EndOfTurn), source);
        }
        return true;
    }
}

