/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.watchers.Watcher;

class AureliasFuryDamagedByWatcher
extends Watcher {
    private final Set<UUID> damagedCreatures = new HashSet<UUID>();
    private final Set<UUID> damagedPlayers = new HashSet<UUID>();

    AureliasFuryDamagedByWatcher() {
        super(WatcherScope.CARD);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case DAMAGED_PERMANENT: {
                Permanent permanent = game.getPermanent(event.getTargetId());
                if (!this.isOurSource(event, game) || permanent == null || !permanent.isCreature(game)) break;
                this.damagedCreatures.add(event.getTargetId());
                break;
            }
            case DAMAGED_PLAYER: {
                if (!this.isOurSource(event, game)) break;
                this.damagedPlayers.add(event.getTargetId());
            }
        }
    }

    private boolean isOurSource(GameEvent event, Game game) {
        MageObject obj = game.getObject(event.getSourceId());
        return obj instanceof Spell && this.sourceId.equals(((Spell)obj).getSourceId());
    }

    public void reset() {
        super.reset();
        this.damagedCreatures.clear();
        this.damagedPlayers.clear();
    }

    Set<UUID> getDamagedCreatures() {
        return this.damagedCreatures;
    }

    Set<UUID> getDamagedPlayers() {
        return this.damagedPlayers;
    }
}

