/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Arrays;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.DealsDamageToYouAllTriggeredAbility;
import mage.abilities.common.LeavesBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.RemoveAllCountersAllEffect;
import mage.abilities.effects.common.continuous.BecomesSubtypeAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.keyword.DefenderAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;

public final class Aurification
extends CardImpl {
    private static final FilterCreaturePermanent filter = new FilterCreaturePermanent("Each creature with a gold counter on it");
    static final String rule = "Each creature with a gold counter on it is a Wall in addition to its other creature types and has defender.";

    public Aurification(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{2}{W}{W}");
        this.addAbility((Ability)new DealsDamageToYouAllTriggeredAbility((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, (Effect)new AddCountersTargetEffect(CounterType.GOLD.createInstance()).setText("put a gold counter on it"), false));
        BecomesSubtypeAllEffect becomesSubtypeAllEffect = new BecomesSubtypeAllEffect(Duration.WhileOnBattlefield, Arrays.asList(SubType.WALL), filter, false);
        becomesSubtypeAllEffect.setText("");
        this.addAbility((Ability)new SimpleStaticAbility((Effect)becomesSubtypeAllEffect));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new GainAbilityAllEffect((Ability)DefenderAbility.getInstance(), Duration.WhileOnBattlefield, (FilterPermanent)filter, rule)));
        this.addAbility((Ability)new LeavesBattlefieldTriggeredAbility((Effect)new RemoveAllCountersAllEffect(CounterType.GOLD, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURES), false));
    }

    private Aurification(Aurification card) {
        super((CardImpl)card);
    }

    public Aurification copy() {
        return new Aurification(this);
    }

    static {
        filter.add((Predicate)CounterType.GOLD.getPredicate());
    }
}

