/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageControllerEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class AurraSingBaneOfJediEffect
extends OneShotEffect {
    AurraSingBaneOfJediEffect() {
        super(Outcome.Damage);
        this.staticText = "You may have {this} deal 2 damage to target creature. If you don't, {this} deals 1 damage to you";
    }

    private AurraSingBaneOfJediEffect(AurraSingBaneOfJediEffect effect) {
        super((OneShotEffect)effect);
    }

    public AurraSingBaneOfJediEffect copy() {
        return new AurraSingBaneOfJediEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            if (controller.chooseUse(this.outcome, "Deal 2 damage to " + game.getPermanent(this.getTargetPointer().getFirst(game, source)).getName() + '?', source, game)) {
                new DamageTargetEffect(2).apply(game, source);
            } else {
                new DamageControllerEffect(1).apply(game, source);
            }
            return true;
        }
        return false;
    }
}

