/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.choices.Choice;
import mage.choices.ChoiceImpl;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class AvenCourierEffect
extends OneShotEffect {
    AvenCourierEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a counter on a permanent you control. Put a counter of that kind on target permanent you control if it doesn't have a counter of that kind on it";
    }

    private AvenCourierEffect(AvenCourierEffect effect) {
        super((OneShotEffect)effect);
    }

    public AvenCourierEffect copy() {
        return new AvenCourierEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        String counterType;
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (player == null || permanent == null) {
            return false;
        }
        Set counterTypes = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_CONTROLLED_PERMANENT, source.getControllerId(), source, game).stream().map(p -> p.getCounters(game)).map(HashMap::keySet).flatMap(Collection::stream).distinct().collect(Collectors.toSet());
        switch (counterTypes.size()) {
            case 0: {
                return false;
            }
            case 1: {
                counterType = (String)counterTypes.iterator().next();
                break;
            }
            case 2: {
                Iterator iterator = counterTypes.iterator();
                String type1 = (String)iterator.next();
                String type2 = (String)iterator.next();
                counterType = player.chooseUse(this.outcome, "Choose a counter to put on " + permanent.getName(), null, CardUtil.getTextWithFirstCharUpperCase((String)type1), CardUtil.getTextWithFirstCharUpperCase((String)type2), source, game) ? type1 : type2;
                break;
            }
            default: {
                ChoiceImpl choice = new ChoiceImpl(true);
                choice.setChoices(counterTypes);
                player.choose(this.outcome, (Choice)choice, game);
                counterType = choice.getChoice();
            }
        }
        return permanent.getCounters(game).getCount(counterType) < 1 && permanent.addCounters(CounterType.findByName((String)counterType).createInstance(), source, game);
    }
}

