/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class AvenEffect
extends ContinuousEffectImpl {
    AvenEffect() {
        super(Duration.Custom, Layer.PTChangingEffects_7, SubLayer.SetPT_7b, Outcome.BoostCreature);
        this.staticText = "If you do, that creature has base power and toughness 3/1 and has flying for as long as it has a feather counter on it";
    }

    private AvenEffect(AvenEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public AvenEffect copy() {
        return new AvenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target == null) {
            return false;
        }
        target.getPower().setModifiedBaseValue(3);
        target.getToughness().setModifiedBaseValue(1);
        return true;
    }

    public boolean isInactive(Ability source, Game game) {
        Permanent creature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        return creature != null && creature.getCounters(game).getCount(CounterType.FEATHER) < 1;
    }
}

