/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AvenSoulgazerLookFaceDownEffect
extends OneShotEffect {
    AvenSoulgazerLookFaceDownEffect() {
        super(Outcome.Benefit);
        this.staticText = "Look at target face-down creature";
    }

    private AvenSoulgazerLookFaceDownEffect(AvenSoulgazerLookFaceDownEffect effect) {
        super((OneShotEffect)effect);
    }

    public AvenSoulgazerLookFaceDownEffect copy() {
        return new AvenSoulgazerLookFaceDownEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject mageObject = game.getObject(source);
        if (player == null || mageObject == null) {
            return false;
        }
        Permanent faceDownCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (faceDownCreature == null) {
            return false;
        }
        player.lookAtCards("face down cards " + mageObject.getName(), (Card)faceDownCreature, game);
        return true;
    }
}

