/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;
import mage.target.common.TargetCreaturePermanentAmount;

class AwakenTheMaelstromEffect
extends OneShotEffect {
    AwakenTheMaelstromEffect() {
        super(Outcome.Benefit);
        this.staticText = "Create a token that's a copy of a permanent you control. Distribute three +1/+1 counters among one, two, or three creatures you control.";
    }

    private AwakenTheMaelstromEffect(AwakenTheMaelstromEffect effect) {
        super((OneShotEffect)effect);
    }

    public AwakenTheMaelstromEffect copy() {
        return new AwakenTheMaelstromEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        this.makeToken(player, game, source);
        game.processAction();
        this.distributeCounters(player, game, source);
        return true;
    }

    private void makeToken(Player player, Game game, Ability source) {
        TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
        target.withNotTarget(true);
        target.withChooseHint("to copy");
        if (!target.canChoose(player.getId(), source, game)) {
            return;
        }
        player.choose(this.outcome, (Target)target, source, game);
        Permanent permanent = game.getPermanent(target.getFirstTarget());
        if (permanent != null) {
            new CreateTokenCopyTargetEffect().setSavedPermanent(permanent).apply(game, source);
        }
    }

    private void distributeCounters(Player player, Game game, Ability source) {
        if (game.getBattlefield().count((FilterPermanent)StaticFilters.FILTER_CONTROLLED_CREATURE, player.getId(), source, game) < 1) {
            return;
        }
        TargetCreaturePermanentAmount target = new TargetCreaturePermanentAmount(3, StaticFilters.FILTER_CONTROLLED_CREATURE);
        target.withNotTarget(true);
        target.withChooseHint("to distribute counters");
        target.chooseTarget(this.outcome, player.getId(), source, game);
        for (UUID targetId : target.getTargets()) {
            Permanent permanent = game.getPermanent(targetId);
            if (permanent == null) continue;
            permanent.addCounters(CounterType.P1P1.createInstance(target.getTargetAmount(targetId)), source, game);
        }
    }
}

