/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectData;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AweStrikeEffect
extends PreventionEffectImpl {
    AweStrikeEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, false, false);
        this.staticText = "The next time target creature would deal damage this turn, prevent that damage. You gain life equal to the damage prevented this way";
    }

    private AweStrikeEffect(AweStrikeEffect effect) {
        super((PreventionEffectImpl)effect);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventionEffectData preventionData = this.preventDamageAction(event, source, game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(preventionData.getPreventedDamage(), game, source);
        }
        this.used = true;
        this.discard();
        return true;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            return targetCreature != null && targetCreature.getId().equals(event.getSourceId());
        }
        return false;
    }

    public AweStrikeEffect copy() {
        return new AweStrikeEffect(this);
    }
}

