/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCosts;
import mage.abilities.effects.PayCostToAttackBlockEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class AwesomePresenceRestrictionEffect
extends PayCostToAttackBlockEffectImpl {
    AwesomePresenceRestrictionEffect(ManaCosts manaCosts) {
        super(Duration.WhileOnBattlefield, Outcome.Neutral, PayCostToAttackBlockEffectImpl.RestrictType.BLOCK, (Cost)manaCosts);
        this.staticText = "Enchanted creature can't be blocked unless defending player pays " + (manaCosts == null ? "" : manaCosts.getText() + " for each creature they control that's blocking it");
    }

    private AwesomePresenceRestrictionEffect(AwesomePresenceRestrictionEffect effect) {
        super((PayCostToAttackBlockEffectImpl)effect);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Player defendingPlayer;
        Permanent blockingCreature = game.getPermanent(event.getSourceId());
        Permanent enchantedAttackingCreature = game.getPermanent(event.getTargetId());
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (blockingCreature != null && enchantedAttackingCreature != null && enchantment != null && enchantment.isAttachedTo(enchantedAttackingCreature.getId()) && (defendingPlayer = game.getPlayer(blockingCreature.getControllerId())) != null) {
            return !this.manaCosts.canPay(source, source, defendingPlayer.getId(), game) || !this.manaCosts.pay(source, game, source, defendingPlayer.getId(), false);
        }
        return true;
    }

    public AwesomePresenceRestrictionEffect copy() {
        return new AwesomePresenceRestrictionEffect(this);
    }
}

