/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class AzorsGatewayEffect
extends OneShotEffect {
    AzorsGatewayEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then exile a card from your hand";
    }

    private AzorsGatewayEffect(AzorsGatewayEffect effect) {
        super((OneShotEffect)effect);
    }

    public AzorsGatewayEffect copy() {
        return new AzorsGatewayEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        TargetCardInHand target = new TargetCardInHand();
        target.withChooseHint("to exile");
        player.choose(this.outcome, player.getHand(), (TargetCard)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCardsToExile(card, source, game, true, CardUtil.getExileZoneId((Game)game, (Ability)source), CardUtil.getSourceLogName((Game)game, (Ability)source));
    }
}

