/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class CastSpellYourLastTurnWatcher
extends Watcher {
    private final Map<UUID, Integer> amountOfSpellsCastOnPrevTurn = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> amountOfSpellsCastOnCurrentTurn = new HashMap<UUID, Integer>();
    private UUID lastActivePlayer = null;

    CastSpellYourLastTurnWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        UUID playerId;
        this.lastActivePlayer = game.getActivePlayerId();
        if (event.getType() == GameEvent.EventType.SPELL_CAST && (playerId = event.getPlayerId()) != null && playerId.equals(this.lastActivePlayer)) {
            this.amountOfSpellsCastOnCurrentTurn.putIfAbsent(playerId, 0);
            this.amountOfSpellsCastOnCurrentTurn.compute(playerId, (k, a) -> a + 1);
        }
    }

    public void reset() {
        super.reset();
        if (this.lastActivePlayer != null && this.amountOfSpellsCastOnPrevTurn.get(this.lastActivePlayer) != null) {
            this.amountOfSpellsCastOnPrevTurn.remove(this.lastActivePlayer);
        }
        this.amountOfSpellsCastOnPrevTurn.putAll(this.amountOfSpellsCastOnCurrentTurn);
        this.amountOfSpellsCastOnCurrentTurn.clear();
        this.lastActivePlayer = null;
    }

    public Integer getAmountOfSpellsCastOnPlayersTurn(UUID playerId) {
        return this.amountOfSpellsCastOnPrevTurn.getOrDefault(playerId, 0);
    }
}

