/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class DamagedByPiratesWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> damageSourceIds = new HashMap<UUID, Set<UUID>>();

    public DamagedByPiratesWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent creature;
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && ((DamagedPlayerEvent)event).isCombatDamage() && (creature = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && creature.hasSubtype(SubType.PIRATE, game)) {
            if (this.damageSourceIds.containsKey(event.getTargetId())) {
                this.damageSourceIds.get(event.getTargetId()).add(creature.getId());
            } else {
                HashSet<UUID> creatureSet = new HashSet<UUID>();
                creatureSet.add(creature.getId());
                this.damageSourceIds.put(event.getTargetId(), creatureSet);
            }
        }
    }

    public boolean damagedByEnoughPirates(UUID sourceId) {
        return this.damageSourceIds.containsKey(sourceId) && this.damageSourceIds.get(sourceId).size() > 2;
    }

    public void reset() {
        super.reset();
        this.damageSourceIds.clear();
    }
}

