/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;

class EchoingEquationEffect
extends OneShotEffect {
    EchoingEquationEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose target creature you control. Each other creature you control becomes a copy of it until end of turn, except those creatures aren't legendary";
    }

    private EchoingEquationEffect(EchoingEquationEffect effect) {
        super((OneShotEffect)effect);
    }

    public EchoingEquationEffect copy() {
        return new EchoingEquationEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent copyFrom = game.getPermanent(source.getFirstTarget());
        if (copyFrom != null) {
            game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().filter(permanent -> permanent.isCreature(game) && !permanent.getId().equals(copyFrom.getId())).forEach(copyTo -> game.copyPermanent(Duration.EndOfTurn, copyFrom, copyTo.getId(), source, new CopyApplier(){

                public boolean apply(Game game, MageObject blueprint, Ability source, UUID targetObjectId) {
                    blueprint.removeSuperType(SuperType.LEGENDARY);
                    return true;
                }
            }));
            return true;
        }
        return false;
    }
}

