/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.game.Game;
import mage.players.Player;

class MostCardsInOpponentsHandCount
implements DynamicValue {
    MostCardsInOpponentsHandCount() {
    }

    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        int maxCards = 0;
        for (UUID opponentId : game.getOpponents(sourceAbility.getControllerId())) {
            int cards;
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null || (cards = opponent.getHand().size()) <= maxCards) continue;
            maxCards = cards;
        }
        return maxCards;
    }

    public MostCardsInOpponentsHandCount copy() {
        return new MostCardsInOpponentsHandCount();
    }

    public String getMessage() {
        return "cards in the hand of the opponent with the most cards in hand";
    }

    public String toString() {
        return "1";
    }
}

