/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.b.BabaLysagaNightWitchSacrificeCost;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BabaLysagaNightWitchEffect
extends OneShotEffect {
    BabaLysagaNightWitchEffect() {
        super(Outcome.Benefit);
        this.staticText = "if there were three or more card types among the sacrificed permanents, each opponent loses 3 life, you gain 3 life, and you draw three cards";
    }

    private BabaLysagaNightWitchEffect(BabaLysagaNightWitchEffect effect) {
        super((OneShotEffect)effect);
    }

    public BabaLysagaNightWitchEffect copy() {
        return new BabaLysagaNightWitchEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (CardUtil.castStream((Stream)source.getCosts().stream(), BabaLysagaNightWitchSacrificeCost.class).filter(Objects::nonNull).map(BabaLysagaNightWitchSacrificeCost::getCardTypes).flatMap(Collection::stream).distinct().count() < 3L) {
            return false;
        }
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            opponent.loseLife(3, game, source, false);
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            controller.gainLife(3, game, source);
            controller.drawCards(3, source, game);
        }
        return true;
    }
}

