/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BacklashEffect
extends OneShotEffect {
    BacklashEffect() {
        super(Outcome.Detriment);
        this.staticText = "Tap target untapped creature. That creature deals damage equal to its power to its controller.";
    }

    private BacklashEffect(BacklashEffect effect) {
        super((OneShotEffect)effect);
    }

    public BacklashEffect copy() {
        return new BacklashEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (targetCreature != null) {
            targetCreature.tap(source, game);
            Player controller = game.getPlayer(targetCreature.getControllerId());
            if (controller != null) {
                controller.damage(targetCreature.getPower().getValue(), targetCreature.getId(), source, game);
                return true;
            }
        }
        return false;
    }
}

