/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesFaceDownCreatureAllEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.PermanentIdPredicate;
import mage.game.Game;
import mage.target.Target;

class BackslideEffect
extends OneShotEffect {
    BackslideEffect() {
        super(Outcome.Benefit);
        this.staticText = "Turn target creature with a morph ability face down.";
    }

    private BackslideEffect(BackslideEffect effect) {
        super((OneShotEffect)effect);
    }

    public BackslideEffect copy() {
        return new BackslideEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        PermanentIdPredicate pred = new PermanentIdPredicate(UUID.randomUUID());
        for (Target target : source.getTargets()) {
            for (UUID targetId : target.getTargets()) {
                pred = Predicates.or((Predicate)pred, (Predicate)new PermanentIdPredicate(targetId));
            }
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)pred);
        game.addEffect((ContinuousEffect)new BecomesFaceDownCreatureAllEffect((FilterPermanent)filter), source);
        return true;
    }
}

