/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInExile;
import mage.util.CardUtil;

class BagOfDevouringEffect
extends OneShotEffect {
    BagOfDevouringEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "roll a d10. Return up to X cards from among cards exiled with {this} to their owners' hands, where X is the result";
    }

    private BagOfDevouringEffect(BagOfDevouringEffect effect) {
        super((OneShotEffect)effect);
    }

    public BagOfDevouringEffect copy() {
        return new BagOfDevouringEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(Outcome.Benefit, source, game, 10);
        TargetCardInExile target = new TargetCardInExile(0, result, StaticFilters.FILTER_CARD, CardUtil.getExileZoneId((Game)game, (Ability)source));
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        player.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
        return true;
    }
}

