/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BagOfTricksEffect
extends OneShotEffect {
    BagOfTricksEffect() {
        super(Outcome.Benefit);
        this.staticText = "roll a d8. Reveal cards from the top of your library until you reveal a creature card with mana value equal to the result. Put that card onto the battlefield and the rest on the bottom of your library in a random order";
    }

    private BagOfTricksEffect(BagOfTricksEffect effect) {
        super((OneShotEffect)effect);
    }

    public BagOfTricksEffect copy() {
        return new BagOfTricksEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int result = player.rollDice(this.outcome, source, game, 8);
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (!card.isCreature(game) || card.getManaValue() != result) continue;
            player.moveCards(card, Zone.BATTLEFIELD, source, game);
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        cards.retainZone(Zone.LIBRARY, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

