/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BakisCurseEffect
extends OneShotEffect {
    public BakisCurseEffect() {
        super(Outcome.Detriment);
        this.staticText = "{this} deals 2 damage to each creature for each Aura attached to that creature.";
    }

    private BakisCurseEffect(BakisCurseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BakisCurseEffect copy() {
        return new BakisCurseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (Permanent creature : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterCreaturePermanent(), source.getControllerId(), source, game)) {
            int count = 0;
            List attachments = creature.getAttachments();
            for (UUID attachmentId : attachments) {
                Permanent attached = game.getPermanent(attachmentId);
                if (attached == null || !attached.hasSubtype(SubType.AURA, game)) continue;
                ++count;
            }
            creature.damage(count * 2, source.getId(), source, game, false, true);
        }
        return true;
    }
}

