/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;

class BalancingActDiscardEffect
extends OneShotEffect {
    BalancingActDiscardEffect() {
        super(Outcome.Discard);
        this.staticText = "Each player discards cards the same way";
    }

    private BalancingActDiscardEffect(BalancingActDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public BalancingActDiscardEffect copy() {
        return new BalancingActDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int minCard = Integer.MAX_VALUE;
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            player = game.getPlayer(playerId);
            if (player == null) continue;
            minCard = Math.min(minCard, player.getHand().size());
        }
        for (UUID playerId : game.getState().getPlayersInRange(controller.getId(), game)) {
            TargetCardInHand target;
            player = game.getPlayer(playerId);
            if (player == null || !(target = new TargetCardInHand(minCard, StaticFilters.FILTER_CARD)).choose(Outcome.Benefit, player.getId(), source.getSourceId(), source, game)) continue;
            Cards cards = player.getHand().copy();
            cards.removeIf(target.getTargets()::contains);
            player.discard(cards, false, source, game);
        }
        return true;
    }
}

