/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BaneFireEffect
extends OneShotEffect {
    BaneFireEffect() {
        super(Outcome.Damage);
        this.staticText = "{this} deals X damage to any target";
    }

    private BaneFireEffect(BaneFireEffect effect) {
        super((OneShotEffect)effect);
    }

    public BaneFireEffect copy() {
        return new BaneFireEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean preventable;
        Player targetPlayer = game.getPlayer(source.getFirstTarget());
        Permanent targetCreature = game.getPermanent(source.getFirstTarget());
        int damage = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        boolean bl = preventable = damage < 5;
        if (targetPlayer != null) {
            targetPlayer.damage(damage, source.getSourceId(), source, game, false, preventable);
            return true;
        }
        if (targetCreature != null) {
            targetCreature.damage(damage, source.getSourceId(), source, game, false, preventable);
            return true;
        }
        return false;
    }
}

