/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PutCardFromHandOntoBattlefieldEffect;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ToughnessPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BaneLordOfDarknessEffect
extends OneShotEffect {
    BaneLordOfDarknessEffect() {
        super(Outcome.Benefit);
        this.staticText = "target opponent may have you draw a card. If they don't, you may put a creature card with equal or lesser toughness from your hand onto the battlefield";
    }

    private BaneLordOfDarknessEffect(BaneLordOfDarknessEffect effect) {
        super((OneShotEffect)effect);
    }

    public BaneLordOfDarknessEffect copy() {
        return new BaneLordOfDarknessEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        if (opponent.chooseUse(this.outcome, "Have " + controller.getName() + " draw a card or put a creature into play?", null, "Draw card", "Play creature", source, game)) {
            return controller.drawCards(1, source, game) > 0;
        }
        Permanent permanent = (Permanent)this.getValue("creatureDied");
        if (permanent == null) {
            return false;
        }
        FilterCreatureCard filter = new FilterCreatureCard("creature card with " + permanent.getToughness().getValue() + " or less toughness");
        filter.add((Predicate)new ToughnessPredicate(ComparisonType.FEWER_THAN, permanent.getToughness().getValue() + 1));
        return new PutCardFromHandOntoBattlefieldEffect((FilterCard)filter).apply(game, source);
    }
}

