/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.dynamicvalue.common.GetXValue;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.Card;
import mage.cards.b.testCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class BanefireCantCounterEffect
extends ContinuousRuleModifyingEffectImpl {
    private Condition condition = new testCondition((DynamicValue)GetXValue.instance, 5);

    public BanefireCantCounterEffect() {
        super(Duration.WhileOnStack, Outcome.Benefit);
        this.staticText = "If X is 5 or more, this spell can't be countered and the damage can't be prevented";
    }

    private BanefireCantCounterEffect(BanefireCantCounterEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
        this.condition = effect.condition;
    }

    public BanefireCantCounterEffect copy() {
        return new BanefireCantCounterEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Card card = game.getCard(source.getSourceId());
        if (card == null) {
            return false;
        }
        UUID spellId = card.getSpellAbility().getId();
        if (!event.getTargetId().equals(spellId)) {
            return false;
        }
        return this.condition.apply(game, source);
    }
}

