/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BanefulOmenEffect
extends OneShotEffect {
    BanefulOmenEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top card of your library. If you do, each opponent loses life equal to that card's mana value";
    }

    private BanefulOmenEffect(BanefulOmenEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !player.getLibrary().hasCards()) {
            return false;
        }
        Card card = player.getLibrary().getFromTop(game);
        if (card == null) {
            return false;
        }
        player.revealCards("Baneful Omen", (Cards)new CardsImpl(card), game);
        int mv = card.getManaValue();
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            opponent.loseLife(mv, game, source, false);
        }
        return true;
    }

    public BanefulOmenEffect copy() {
        return new BanefulOmenEffect(this);
    }
}

