/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;

class BanishIntoFableEffect
extends OneShotEffect {
    private final UUID spellId;

    BanishIntoFableEffect(UUID spellId) {
        super(Outcome.Benefit);
        this.spellId = spellId;
    }

    private BanishIntoFableEffect(BanishIntoFableEffect effect) {
        super((OneShotEffect)effect);
        this.spellId = effect.spellId;
    }

    public BanishIntoFableEffect copy() {
        return new BanishIntoFableEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpellOrLKIStack(this.spellId);
        if (spell == null) {
            return false;
        }
        if (game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().filter(permanent -> permanent.isArtifact(game)).count() > 0L) {
            spell.createCopyOnStack(game, source, source.getControllerId(), true);
        }
        if (game.getBattlefield().getAllActivePermanents(source.getControllerId()).stream().filter(permanent -> permanent.isEnchantment(game)).count() > 0L) {
            spell.createCopyOnStack(game, source, source.getControllerId(), true);
        }
        return true;
    }
}

