/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BannerOfKinshipEffect
extends OneShotEffect {
    BannerOfKinshipEffect() {
        super(Outcome.BoostCreature);
        this.staticText = "This artifact enters with a fellowship counter on it for each creature you control of the chosen type";
    }

    private BannerOfKinshipEffect(BannerOfKinshipEffect effect) {
        super((OneShotEffect)effect);
    }

    public BannerOfKinshipEffect copy() {
        return new BannerOfKinshipEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanentEntering(source.getSourceId());
        if (controller == null || permanent == null) {
            return false;
        }
        SubType subtype = (SubType)game.getState().getValue(source.getSourceId() + "_type");
        int amount = game.getBattlefield().getAllActivePermanents((FilterPermanent)new FilterControlledCreaturePermanent(subtype), source.getControllerId(), game).size();
        if (amount > 0) {
            permanent.addCounters(CounterType.FELLOWSHIP.createInstance(amount), source.getControllerId(), source, game);
        }
        return true;
    }
}

