/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.mageobject.AnotherPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BartzAndBokoEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterControlledPermanent(SubType.BIRD);

    BartzAndBokoEffect() {
        super(Outcome.Benefit);
        this.staticText = "each other Bird you control deals damage equal to its power to target creature an opponent controls";
    }

    private BartzAndBokoEffect(BartzAndBokoEffect effect) {
        super((OneShotEffect)effect);
    }

    public BartzAndBokoEffect copy() {
        return new BartzAndBokoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        for (Permanent bird : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
            permanent.damage(bird.getPower().getValue(), bird.getId(), source, game);
        }
        return true;
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)AnotherPredicate.instance);
    }
}

