/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.constants.Duration;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BasriDevotedPaladinTriggeredAbility
extends DelayedTriggeredAbility {
    public BasriDevotedPaladinTriggeredAbility() {
        super((Effect)new AddCountersTargetEffect(CounterType.P1P1.createInstance()), Duration.EndOfTurn, false);
    }

    private BasriDevotedPaladinTriggeredAbility(BasriDevotedPaladinTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public BasriDevotedPaladinTriggeredAbility copy() {
        return new BasriDevotedPaladinTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent = game.getPermanent(event.getSourceId());
        if (permanent != null) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature attacks this turn, put a +1/+1 counter on it.";
    }
}

