/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Duration;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.SoldierToken;
import mage.game.permanent.token.Token;

class BasriKetTriggeredAbility
extends DelayedTriggeredAbility {
    public BasriKetTriggeredAbility() {
        super(null, Duration.EndOfTurn, false);
    }

    private BasriKetTriggeredAbility(BasriKetTriggeredAbility ability) {
        super((DelayedTriggeredAbility)ability);
    }

    public BasriKetTriggeredAbility copy() {
        return new BasriKetTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        int attackingNonTokens = 0;
        for (UUID attacker : game.getCombat().getAttackers()) {
            Permanent permanent = game.getPermanent(attacker);
            if (!StaticFilters.FILTER_CREATURE_NON_TOKEN.match((Object)permanent, game)) continue;
            ++attackingNonTokens;
        }
        if (attackingNonTokens > 0) {
            this.getEffects().clear();
            this.addEffect((Effect)new CreateTokenEffect((Token)new SoldierToken(), attackingNonTokens, true, true));
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever one or more nontoken creatures attack this turn, create that many 1/1 white Soldier creature tokens that are tapped and attacking.";
    }
}

