/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.token.TreasureToken;
import mage.players.Player;
import mage.util.CardUtil;

class BattleAngelsOfTyrEffect
extends OneShotEffect {
    BattleAngelsOfTyrEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card if that player has more cards in hand than each other player. Then you create a Treasure token if that player controls more lands than each other player. Then you gain 3 life if that player has more life than each other player";
    }

    private BattleAngelsOfTyrEffect(BattleAngelsOfTyrEffect effect) {
        super((OneShotEffect)effect);
    }

    public BattleAngelsOfTyrEffect copy() {
        return new BattleAngelsOfTyrEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Map map;
        Player controller = game.getPlayer(source.getControllerId());
        Player player = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || player == null) {
            return false;
        }
        Set players = game.getState().getPlayersInRange(source.getControllerId(), game).stream().filter(uuid -> !player.getId().equals(uuid)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        if (players.stream().map(Player::getHand).mapToInt(Set::size).allMatch(x -> player.getHand().size() > x)) {
            controller.drawCards(1, source, game);
        }
        if ((map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_LAND, source.getControllerId(), game).stream().map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), x -> 1, CardUtil::setOrIncrementValue))).getOrDefault(player.getId(), 0) > map.entrySet().stream().filter(e -> !player.getId().equals(e.getKey())).mapToInt(Map.Entry::getValue).max().orElse(0)) {
            new TreasureToken().putOntoBattlefield(1, game, source);
        }
        if (players.stream().mapToInt(Player::getLife).allMatch(x -> player.getLife() > x)) {
            controller.gainLife(3, game, source);
        }
        return true;
    }
}

