/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class BeaconOfImmortalityEffect
extends OneShotEffect {
    BeaconOfImmortalityEffect() {
        super(Outcome.GainLife);
        this.staticText = "Double target player's life total";
    }

    private BeaconOfImmortalityEffect(BeaconOfImmortalityEffect effect) {
        super((OneShotEffect)effect);
    }

    public BeaconOfImmortalityEffect copy() {
        return new BeaconOfImmortalityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getFirstTarget());
        if (player != null) {
            int amount = player.getLife();
            if (amount < 0) {
                player.loseLife(-amount, game, source, false);
                return true;
            }
            if (amount > 0) {
                player.gainLife(amount, game, source);
                return true;
            }
        }
        return false;
    }
}

