/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.TreasureToken;

class BeamtownBeatstickTriggeredAbility
extends TriggeredAbilityImpl {
    BeamtownBeatstickTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new CreateTokenEffect((Token)new TreasureToken()));
        this.setTriggerPhrase("Whenever equipped creature deals combat damage to a player or battle, ");
    }

    private BeamtownBeatstickTriggeredAbility(BeamtownBeatstickTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BeamtownBeatstickTriggeredAbility copy() {
        return new BeamtownBeatstickTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedEvent dEvent = (DamagedEvent)event;
        if (!dEvent.isCombatDamage()) {
            return false;
        }
        Permanent equipment = this.getSourcePermanentOrLKI(game);
        if (!dEvent.getSourceId().equals(equipment.getAttachedTo())) {
            return false;
        }
        switch (event.getType()) {
            case DAMAGED_PERMANENT: {
                Permanent permanent = game.getPermanent(dEvent.getTargetId());
                return permanent != null && permanent.isBattle(game);
            }
            case DAMAGED_PLAYER: {
                return true;
            }
        }
        return false;
    }
}

