/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.watchers.Watcher;

class BelbeCorruptedObserverWatcher
extends Watcher {
    private final Map<UUID, Set<UUID>> opponentsWhoLostLife = new HashMap<UUID, Set<UUID>>();

    BelbeCorruptedObserverWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.LOST_LIFE) {
            return;
        }
        game.getOpponents(event.getPlayerId()).forEach(uuid -> this.opponentsWhoLostLife.computeIfAbsent((UUID)uuid, x -> new HashSet()).add(event.getPlayerId()));
    }

    public void reset() {
        this.opponentsWhoLostLife.clear();
        super.reset();
    }

    int getOpponentCount(UUID controllerId) {
        return this.opponentsWhoLostLife.computeIfAbsent(controllerId, x -> new HashSet()).size();
    }
}

