/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.cards.b.CombatDamageStepStartedWatcher;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class BerserkReplacementEffect
extends ContinuousRuleModifyingEffectImpl {
    BerserkReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "Cast this spell only before the combat damage step";
    }

    private BerserkReplacementEffect(BerserkReplacementEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(source.getSourceId())) {
            CombatDamageStepStartedWatcher watcher = (CombatDamageStepStartedWatcher)game.getState().getWatcher(CombatDamageStepStartedWatcher.class);
            return watcher == null || watcher.conditionMet();
        }
        return false;
    }

    public BerserkReplacementEffect copy() {
        return new BerserkReplacementEffect(this);
    }
}

