/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.BlocksIfAbleTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class BerserkersFrenzyEffect
extends OneShotEffect {
    BerserkersFrenzyEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose any number of creatures. They block this turn if able";
    }

    private BerserkersFrenzyEffect(BerserkersFrenzyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BerserkersFrenzyEffect copy() {
        return new BerserkersFrenzyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCreaturePermanent target = new TargetCreaturePermanent(0, Integer.MAX_VALUE);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        game.addEffect(new BlocksIfAbleTargetEffect(Duration.EndOfTurn).setTargetPointer((TargetPointer)new FixedTargets((Cards)new CardsImpl((Collection)target.getTargets()), game)), source);
        return true;
    }
}

