/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.PhaseStep;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BewitchingLeechcraftReplacementEffect
extends ReplacementEffectImpl {
    BewitchingLeechcraftReplacementEffect() {
        super(Duration.EndOfGame, Outcome.Detriment);
        this.staticText = "If this creature would untap during your untap step, remove a +1/+1 counter from it instead. If you do, untap it.";
    }

    private BewitchingLeechcraftReplacementEffect(BewitchingLeechcraftReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BewitchingLeechcraftReplacementEffect copy() {
        return new BewitchingLeechcraftReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.UNTAP;
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanentUntapping = game.getPermanent(source.getSourceId());
        if (!this.applies(event, source, game)) {
            return false;
        }
        int amountBefore = permanentUntapping.getCounters(game).getCount(CounterType.P1P1);
        permanentUntapping.removeCounters(CounterType.P1P1.getName(), 1, source, game);
        int amountAfter = permanentUntapping.getCounters(game).getCount(CounterType.P1P1);
        return amountBefore <= amountAfter;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return game.getTurnStepType() == PhaseStep.UNTAP && event.getTargetId().equals(source.getSourceId());
    }
}

