/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class BiomancersFamiliarReplacementEffect
extends ReplacementEffectImpl {
    BiomancersFamiliarReplacementEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "The next time target creature adapts this turn, it adapts as though it had no +1/+1 counters on it.";
    }

    private BiomancersFamiliarReplacementEffect(BiomancersFamiliarReplacementEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public BiomancersFamiliarReplacementEffect copy() {
        return new BiomancersFamiliarReplacementEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ADAPT;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return event.getTargetId().equals(this.getTargetPointer().getFirst(game, source));
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        event.setFlag(true);
        this.discard();
        return false;
    }
}

