/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Library;
import mage.players.Player;

class BioplasmEffect
extends OneShotEffect {
    BioplasmEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. If it's a creature card, {this} gets +X/+Y until end of turn, where X is the exiled creature card's power and Y is its toughness";
    }

    private BioplasmEffect(BioplasmEffect effect) {
        super((OneShotEffect)effect);
    }

    public BioplasmEffect copy() {
        return new BioplasmEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (library == null || !library.hasCards()) {
            return false;
        }
        Card card = library.getFromTop(game);
        if (card == null) {
            return false;
        }
        if (player.moveCards(card, Zone.EXILED, source, game) && card.isCreature(game)) {
            game.addEffect((ContinuousEffect)new BoostSourceEffect(card.getPower().getValue(), card.getToughness().getValue(), Duration.EndOfTurn), source);
        }
        return true;
    }
}

