/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.DynamicValue;
import mage.abilities.effects.Effect;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Controllable;
import mage.game.Game;

enum BirthOfTheImperiumValue implements DynamicValue
{
    instance;


    public int calculate(Game game, Ability sourceAbility, Effect effect) {
        Map map = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, sourceAbility.getControllerId(), sourceAbility, game).stream().map(Controllable::getControllerId).collect(Collectors.toMap(Function.identity(), x -> 1, Integer::sum));
        int yourCreatures = map.getOrDefault(sourceAbility.getControllerId(), 0);
        return yourCreatures > 0 ? (int)(2L * game.getOpponents(sourceAbility.getControllerId()).stream().mapToInt(uuid -> map.getOrDefault(uuid, 0)).filter(x -> x < yourCreatures).count()) : 0;
    }

    public BirthOfTheImperiumValue copy() {
        return this;
    }

    public String getMessage() {
        return "opponent who controls fewer creatures than you";
    }

    public String toString() {
        return "two";
    }
}

